#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Exploring the crystal latticeMod01.fsh by  Devin   
//https://www.shadertoy.com/view/XsjXWh
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float rand(vec3 n) {
  n = floor(n);
  n.z = 100.0*fract(n.z/100.0);
  return fract(sin((n.x*1e2+n.y*1e4+n.z*1e6)*1e-4)*1e5);
}

vec3 light( vec3 ray,vec3 lightPos,float cr) {
    vec3 f = fract( ray ) -0.5;
    vec3 normf = normalize(f);
    vec3 light = lightPos-ray;
    float lighting = normf.x*light.x+normf.y*light.y+normf.z*light.z;
    lighting=lighting<0.0?0.0:lighting;
    float l2 = length(light);
	return 3.0*lighting/pow((l2+0.40),2.5)*vec3(0.8*cr,0.5,0.8-cr);
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{   
    vec2 pos = (fragCoord.xy*2.0 - iResolution.xy) / iResolution.y;
    float t = iTime+0.2;
    float tt = iTime+2.0;
    
    //camera
    vec3 camPos = vec3(cos(iTime*0.5), sin(iTime*0.5), -iTime*0.5);
    vec3 camTarget = vec3(cos(t*0.5), sin(t*0.5), -t*0.5);
    vec3 camDir = normalize(camTarget-camPos);
    vec3 camUp  = normalize(vec3(0.0, 1.0, 0.0));
    vec3 camSide = cross(camDir, camUp);
    camUp  = cross(camDir, camSide);
    vec3 rayDir = normalize(camSide*pos.x + camUp*pos.y + camDir*1.5);
    
    //light position
    vec3 lightPos = vec3(cos(tt*0.5), sin(tt*0.5), -tt*0.5);
    lightPos += vec3(0.1*sin(iTime*5.0),0.1*cos(iTime*3.0),0.1*cos(iTime*4.0));
    lightPos -=pow(1.0-2.0*abs(fract(iTime/7.0)-0.5),6.)*(-camDir)*5.0;
    
    //raymarching
    vec3 ray = camPos;
    float l_min = length(cross(lightPos-ray,rayDir));
	float halo = 0.0005/l_min/l_min;
    float cr;
    bool end = true;
    for(int i=0; i<30; ++i) {
		cr = 0.3*rand( ray );
        vec3 bc = floor(ray)+0.5;
        float d_min = length(cross(rayDir,bc-camPos));
        if ((d_min<cr)&&(dot(bc-camPos,camDir)>0.0)){
            
            //determine closest intersection of ray and sphere
         	vec3 d_min_vec = normalize(cross(cross(bc-camPos,rayDir),rayDir));
            float l1 = sqrt(cr*cr-d_min*d_min);
            ray = bc + d_min_vec*d_min-rayDir*l1;
            
            if (length(ray - camPos)<length(lightPos-camPos)) {halo = 0.0;}
            end = false;
            break;
        }
        ray+=0.8*rayDir;
    }
    vec3 color = end?vec3(0.0,0.0,0.0):light(ray,lightPos,cr/0.3);
    fragColor = vec4( color+halo*(1.0,1.0,1.0), 1.0 );;
      

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

